package org.codefilarete.stalactite.sql.ddl;

import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;

/**
 * 
 * @author Guillaume Mary
 */
public class HSQLDBDDLTableGenerator extends DDLTableGenerator {
	
	public HSQLDBDDLTableGenerator(SqlTypeRegistry typeMapping, DMLNameProviderFactory dmlNameProviderFactory) {
		super(typeMapping, dmlNameProviderFactory);
	}
	
	@Override
	protected String getSqlType(Column column) {
		String sqlType = super.getSqlType(column);
		if (column.isAutoGenerated()) {
			sqlType += " GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
		}
		return sqlType;
	}
	
	/**
	 * Overridden to implement HSQLDB "unique" keyword
	 */
	@Override
	protected void generateCreatePrimaryKey(PrimaryKey primaryKey, DDLAppender sqlCreateTable) {
		sqlCreateTable.cat(", unique (")
				.ccat(primaryKey.getColumns(), ", ")
				.cat(")");
	}
}
